//=============================================================================
// Toggle Goals On and Off.
//=============================================================================
class BroopGoalTrigger extends CrateUnbreakableLarge;

//var() BroopGoalUnit TarUnit;
var() bool NewActive;
var() bool bTriggerOnceOnly;

function Trigger(Actor Other, Pawn Instigator)
{
	if (SetActive())
	{
		Super.Trigger(Other, Instigator);
		if (bTriggerOnceOnly)
			Destroy();
	}
}

singular function Touch(Actor Other)
{
	if (SetActive())
		if (bTriggerOnceOnly)
			Destroy();
}

function bool SetActive()
{
	local BroopGoalUnit BGU;
	local bool B;
	
	// find the target NPC to set alliances
	if (Event != '')
		foreach AllActors (class'BroopGoalUnit', BGU, Event)
		{
			BGU.SetActive(NewActive);
			B = True;
		}
	
	return B;
}

defaultproperties
{
 Drawscale=0.500000
 Physics=PHYS_None
 bHidden=True
 bBlockActors=False
 bBlockPlayers=False
 bCollideWorld=False
}
